#############################################################################
#############################################################################
#
# latexNavigation.tcl (sourced on demand)
#
#############################################################################
#
# Author:  Tom Scavo <trscavo@syr.edu>
# Updates 98-99, Vince Darley
#############################################################################
#############################################################################

# Find the next or previous environment.  Search forward (or backward, 
# depending on $forward) for either \begin or \end.  If \begin is found, 
# search forward for corresponding \end; otherwise, search backward for 
# corresponding \begin.  Select the found environment, or display an 
# error message if no environment is found.
proc findEnvironment {forward} {
    set searchString1 {^[ \t]*\\begin\{[^\{\}]*\}|\\end\{[^\{\}]*\}[ \t]*\r?}
    set searchPos [getPos]
    if { [isSelection] } { 
	if { $forward } {
	    set searchPos [selEnd]
	} else {
	    set searchPos [pos::math $searchPos - 1]
	}
    } else {
	if { $forward } {
	    set searchPos [pos::math $searchPos + 1]
	} else {
	    set searchPos [pos::math $searchPos - 1]
	}
    }
    set searchResult [search -s -f $forward -r 1 -n $searchString1 $searchPos]
    if {[llength $searchResult]} {
	set begPos [lindex $searchResult 0]
	set endPos [lindex $searchResult 1]
	set searchText [getText $begPos $endPos]
	regexp {\{(.*)\}} $searchText dummy envName
	set envName [quote::Regfind $envName]
	if {[string match {*begin*} $searchText]} {
	    set begEnv $begPos
	    append searchString2 {\\end\{} $envName {\}[ \t]*\r?}
	    set searchPos $endPos
	    set searchResult [search -s -f 1 -r 1 -n $searchString2 $searchPos]
	    if {[llength $searchResult]} {
		set endPos [lindex $searchResult 1]
		return [list $begPos $endPos]
	    } else {
		return "matching \\end not found"
	    }
	} else {
	    set endEnv $endPos
	    append searchString2 {^[ \t]*\\begin\{} $envName {\}}
	    set searchPos $begPos
	    set searchResult [search -s -f 0 -r 1 -n $searchString2 $searchPos]
	    if {[llength $searchResult]} {
		set begPos [lindex $searchResult 0]
		return [list $begPos $endPos]
	    } else {
		return "matching \\begin not found"
	    }
	}
    } else {
	if { $forward } {
	    return "next environment not found"
	} else {
	    return "previous environment not found"
	}
    }
}

proc prevEnvironment {} {
	global searchNoisily
	set findResult [findEnvironment 0]
	if {[llength $findResult] == 2} {
		goto [lindex $findResult 0]
	} else {
		if {$searchNoisily} {beep}
		message $findResult
	}
}
proc nextEnvironment {} {
	global searchNoisily
	set findResult [findEnvironment 1]
	if {[llength $findResult] == 2} {
		goto [lindex $findResult 0]
	} else {
		if {$searchNoisily} {beep}
		message $findResult
	}
}
proc prevEnvironmentSelect {} {
	global searchNoisily
	set forward 0
	set findResult [findEnvironment $forward]
	if {[llength $findResult] == 2} {
		set endPos [lindex $findResult 1]
# 		if { [regexp {\r} [lookAt [expr $endPos + 1]]] } {
# 			set endPos [expr $endPos + 1]
# 		}
		select [lindex $findResult 0] $endPos
	} else {
		if { $searchNoisily } {beep}
		message $findResult
	}
}
proc nextEnvironmentSelect {} {
	global searchNoisily
	set forward 1
	set findResult [findEnvironment $forward]
	if {[llength $findResult] == 2} {
		set endPos [lindex $findResult 1]
# 		if { [regexp {\r} [lookAt [expr $endPos + 1]]] } {
# 			set endPos [expr $endPos + 1]
# 		}
		select [lindex $findResult 0] $endPos
	} else {
		if { $searchNoisily } {beep}
		message $findResult
	}
}

# Find a LaTeX command in either direction.  It's up to the calling
# procedure to pass the correct starting position of the search.
proc findCommand {pos direction} {
    #	Handle "\ " and "\[" separately:
    set searchString {(\\([^a-zA-Z\t\r* []|[a-zA-Z]+)\*?)|([^\\]\\\ )|([^\\]\\\[)}
    set searchResult [search -s -f $direction -r 1 -n $searchString $pos]
    if { [llength $searchResult] } {
	set begPos [lindex $searchResult 0]
	set endPos [lindex $searchResult 1]
	set lastChar [lookAt [pos::math $endPos - 1]]
	if {$lastChar == "\ " || $lastChar == "\["} {
	    return [list [pos::math $begPos + 1] $endPos]
	} else {}
    }
    return $searchResult
    # Handles everything but "\ " and "\[":
    # 	set searchString {\\([^a-zA-Z\t\r* []|[a-zA-Z]+)\*?}
    # 	return [search -s -f $direction -r 1 -n $searchString $pos]
}
# Find and goto the beginning of the previous LaTeX command.
proc prevCommand {} {
    TeX::prev Command
}
# Find and goto the beginning of the next LaTeX command.
proc nextCommand {} {
    TeX::next Command
}
# Select the previous LaTeX command, but do not attempt to select
# any associated argument.
proc prevCommandSelect {} {
    TeX::prev Command 1
}
# Select the next LaTeX command, but do not attempt to select
# any associated argument.
proc nextCommandSelect {} {
    TeX::next Command 1
}

# Find a LaTeX command with arguments in either direction.  It's up 
# to the calling procedure to pass the starting position of the search.
# (Handles everything but "\ " and commands whose arguments contain
# embedded braces.)
proc findCommandWithArgs {pos direction} {
    set searchString {\\([^a-zA-Z\t\r]|[a-zA-Z]+\*?)(\[.*\])*({[^{}]*})*}
    return [search -s -f $direction -r 1 -n $searchString $pos]
}
# Select the previous LaTeX command and any associated arguments.
proc prevCommandSelectWithArgs {} {
    TeX::prev CommandWithArgs 1 command
}
# Select the next LaTeX command and any associated arguments.
proc nextCommandSelectWithArgs {} {
    TeX::next CommandWithArgs 1 command
}

# Find a LaTeX sectioning command in either direction.  It's up to 
# the calling procedure to pass the starting position of the search.
proc findSection {pos direction} {
    global funcExprAlt
    return [search -s -f $direction -r 1 -n $funcExprAlt $pos]
}
# Select the previous LaTeX sectioning command.
proc prevSection {} {
    TeX::prev Section
}
# Select the next LaTeX sectioning command.
proc nextSection {} {
    TeX::next Section
}
proc prevSectionSelect {} {
    global searchNoisily
    set pos [getPos]
    if {[pos::compare $pos > [minPos]]} {
	set searchResult [findSection [pos::math $pos - 1] 0]
	if { [llength $searchResult] } {
	    set begPos [lindex $searchResult 0]
	    set searchPos [pos::math [lindex $searchResult 1] + 1]
	    set searchResult [findSection $searchPos 1]
	    if { [llength $searchResult] } {
		set endPos [lindex $searchResult 0]
	    } else {
		set searchResult [search -s -f 1 -r 0 -n "\\end{document}" $searchPos]
		if { [llength $searchResult] } {
		    set endPos [lindex $searchResult 0]
		} else {
		    set endPos [maxPos]
		}
	    }
	    select $begPos $endPos
	    return
	}
    }
    if { $searchNoisily } {beep}
    message {previous section not found}
}
# Select the next LaTeX sectioning command.
proc nextSectionSelect {} {
    global searchNoisily
    set pos [getPos]
    if {$pos < [maxPos]} {
	if { [isSelection] } {
	    set pos [pos::math $pos + 1]
	}
	set searchResult [findSection $pos 1]
	if { [llength $searchResult] } {
	    set begPos [lindex $searchResult 0]
	    set searchPos [pos::math [lindex $searchResult 1] + 1]
	    set searchResult [findSection $searchPos 1]
	    if { [llength $searchResult] } {
		set endPos [lindex $searchResult 0]
	    } else {
		set searchResult [search -s -f 1 -r 0 -n "\\end{document}" $searchPos]
		if { [llength $searchResult] } {
		    set endPos [lindex $searchResult 0]
		} else {
		    set endPos [maxPos]
		}
	    }
	    select $begPos $endPos
	    return
	}
    }
    if { $searchNoisily } {beep}
    message {next section not found}
}

# Find a LaTeX subsectioning command in either direction.  It's up to 
# the calling procedure to pass the starting position of the search.
proc findSubsection {pos direction} {
    global funcExpr
    return [search -s -f $direction -r 1 -n $funcExpr $pos]
}
proc prevSubsection {} {
    TeX::prev Subsection
}
# Select the next LaTeX sectioning command.
proc nextSubsection {} {
    TeX::next Subsection
}
proc prevSubsectionSelect {} {
    global searchNoisily
    set pos [getPos]
    if {[pos::compare $pos > [minPos]]} {
	set searchResult [findSubsection [pos::math $pos - 1] 0]
	if { [llength $searchResult] } {
	    set begPos [lindex $searchResult 0]
	    set endPos [lindex $searchResult 1]
	    set searchPos [pos::math $endPos + 1]
	    set commandName [extractCommandName [getText $begPos $endPos]]
	    if {[string match {section*} $commandName]} {
		set searchResult [findSection $searchPos 1]
	    } else {
		set searchResult [findSubsection $searchPos 1]
	    }
	    if { [llength $searchResult] } {
		set endPos [lindex $searchResult 0]
	    } else {
		set searchResult [search -s -f 1 -r 0 -n "\\end{document}" $searchPos]
		if { [llength $searchResult] } {
		    set endPos [lindex $searchResult 0]
		} else {
		    set endPos [maxPos]
		}
	    }
	    select $begPos $endPos
	    return
	} 
    }
    if { $searchNoisily } {beep}
    message {previous (sub)*section not found}
}
# Select the next LaTeX sectioning command.
proc nextSubsectionSelect {} {
    global searchNoisily
    set pos [getPos]
    if {[pos::compare $pos < [maxPos]]} {
	if { [isSelection] } {
	    set pos [pos::math $pos + 1]
	}
	set searchResult [findSubsection $pos 1]
	if { [llength $searchResult] } {
	    set begPos [lindex $searchResult 0]
	    set endPos [lindex $searchResult 1]
	    set searchPos [pos::math $endPos + 1]
	    set commandName [extractCommandName [getText $begPos $endPos]]
	    if {[string match {section*} $commandName]} {
		set searchResult [findSection $searchPos 1]
	    } else {
		set searchResult [findSubsection $searchPos 1]
	    }
	    if { [llength $searchResult] } {
		set endPos [lindex $searchResult 0]
	    } else {
		set searchResult [search -s -f 1 -r 0 -n "\\end{document}" $searchPos]
		if { [llength $searchResult] } {
		    set endPos [lindex $searchResult 0]
		} else {
		    set endPos [maxPos]
		}
	    }
	    select $begPos $endPos
	    return
	} 
    }
    if { $searchNoisily } {beep}
    message {next (sub)*section not found}
}

proc TeX::prev {what {select 0} {msg ""}} {
    global searchNoisily
    set pos [getPos]
    if {[pos::compare $pos > [minPos]]} {
	set searchResult [find$what [pos::math $pos - 1] 0]
	if { [llength $searchResult] } {
	    if {$select} {
		eval select $searchResult
	    } else {
		goto [lindex $searchResult 0]
	    }
	    return
	} 
    }
    if { $searchNoisily } {beep}
    if {$msg == ""} {set msg [string tolower $what]}
    message "previous $msg not found"
}
proc TeX::next {what {select 0} {msg ""}} {
    global searchNoisily
    set pos [getPos]
    if {[pos::compare $pos < [maxPos]]} {
	if { [isSelection] } {
	    set pos [pos::math $pos + 1]
	}
	set searchResult [find$what [pos::math $pos + 1] 1]
	if { [llength $searchResult] } {
	    if {$select} {
		eval select $searchResult
	    } else {
		goto [lindex $searchResult 0]
	    }
	    return
	} 
    }
    if { $searchNoisily } {beep}
    if {$msg == ""} {set msg [string tolower $what]}
    message "next $msg not found"
}
